/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.items;

import de.ambertation.wunderlib.math.Bounds;
import java.util.HashSet;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.commands.arguments.blocks.BlockStateParser;
import net.minecraft.core.BlockPos;
import net.minecraft.core.FrontAndTop;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.worldgen.Pools;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.JigsawBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.JigsawBlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.entity.StructureBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import org.betterx.bclib.client.models.ModelsHelper;
import org.betterx.bclib.commands.PlaceCommand;
import org.betterx.bclib.interfaces.AirSelectionItem;
import org.betterx.bclib.interfaces.ItemModelProvider;
import org.betterx.ui.ColorUtil;

public class DebugDataItem
extends Item
implements ItemModelProvider,
AirSelectionItem {
    public static final ResourceLocation DEFAULT_ICON = new ResourceLocation("stick");
    protected final DebugInteraction interaction;
    protected final ResourceLocation icon;
    public final boolean placeInAir;

    public static InteractionResult fillStructureEntityBounds(UseOnContext useOnContext, BlockEntity entity, BlockStatePredicate predicate, BlockState newState, boolean floodFill) {
        if (entity instanceof StructureBlockEntity) {
            StructureBlockEntity e = (StructureBlockEntity)entity;
            if (floodFill) {
                DebugDataItem.floodFillStructureEntityBounds(useOnContext, e, predicate, newState);
            } else {
                DebugDataItem.fillStructureEntityBounds(useOnContext, e, predicate, newState);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public static void fillStructureEntityBounds(UseOnContext useOnContext, StructureBlockEntity entity, BlockStatePredicate predicate, BlockState newState) {
        Level level = useOnContext.m_43725_();
        Vec3i size = entity.m_155805_();
        BlockPos pos = useOnContext.m_8083_().m_121955_((Vec3i)entity.m_59902_());
        for (int x = 0; x < size.m_123341_(); ++x) {
            for (int y = 0; y < size.m_123342_(); ++y) {
                for (int z = 0; z < size.m_123343_(); ++z) {
                    BlockPos blockPos = pos.m_7918_(x, y, z);
                    BlockState state = level.m_8055_(blockPos);
                    if (!predicate.test(state)) continue;
                    level.m_7731_(blockPos, newState, 18);
                }
            }
        }
    }

    public static void floodFillStructureEntityBounds(UseOnContext useOnContext, StructureBlockEntity entity, BlockStatePredicate predicate, BlockState newState) {
        Bounds bounds = Bounds.of((BlockPos)useOnContext.m_8083_().m_121955_((Vec3i)entity.m_59902_()), (Vec3i)entity.m_155805_());
        DebugDataItem.floodFillStructureEntityBounds(useOnContext.m_43725_(), bounds, bounds.max.toBlockPos(), entity, predicate, newState, new HashSet<BlockPos>());
    }

    private static void floodFillStructureEntityBounds(Level level, Bounds bounds, BlockPos pos, StructureBlockEntity entity, BlockStatePredicate predicate, BlockState newState, Set<BlockPos> visited) {
        if (!bounds.isInside(pos)) {
            return;
        }
        if (visited.contains(pos)) {
            return;
        }
        visited.add(pos);
        if (predicate.test(level.m_8055_(pos))) {
            level.m_7731_(pos, newState, 18);
            DebugDataItem.floodFillStructureEntityBounds(level, bounds, pos.m_7494_(), entity, predicate, newState, visited);
            DebugDataItem.floodFillStructureEntityBounds(level, bounds, pos.m_7495_(), entity, predicate, newState, visited);
            DebugDataItem.floodFillStructureEntityBounds(level, bounds, pos.m_122012_(), entity, predicate, newState, visited);
            DebugDataItem.floodFillStructureEntityBounds(level, bounds, pos.m_122029_(), entity, predicate, newState, visited);
            DebugDataItem.floodFillStructureEntityBounds(level, bounds, pos.m_122019_(), entity, predicate, newState, visited);
            DebugDataItem.floodFillStructureEntityBounds(level, bounds, pos.m_122024_(), entity, predicate, newState, visited);
        }
    }

    public DebugDataItem(DebugEntityInteraction interaction, boolean placeInAir, ResourceLocation icon) {
        this((DebugInteraction)interaction, placeInAir, icon);
    }

    public DebugDataItem(DebugInteraction interaction, boolean placeInAir, ResourceLocation icon) {
        super(new Item.Properties().m_41486_().m_41487_(1));
        this.interaction = interaction;
        this.icon = icon == null ? DEFAULT_ICON : icon;
        this.placeInAir = placeInAir;
    }

    @Override
    public boolean renderAirSelection() {
        return this.placeInAir;
    }

    public boolean m_5812_(ItemStack itemStack) {
        return true;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public BlockModel getItemModel(ResourceLocation resourceLocation) {
        return ModelsHelper.createItemModel(this.icon);
    }

    @Override
    public InteractionResult m_6225_(UseOnContext useOnContext) {
        if (!useOnContext.m_43723_().m_36337_()) {
            return InteractionResult.FAIL;
        }
        return this.interaction.use(useOnContext);
    }

    public static void message(Player player, String text) {
        DebugDataItem.message(player, text, ColorUtil.GRAY);
    }

    public static void message(Player player, String text, int color) {
        DebugDataItem.message(player, (Component)Component.m_237113_((String)text).m_130948_(Style.f_131099_.m_178520_(color)));
    }

    public static void message(Player player, Component component) {
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            sp.m_240418_(component, true);
        }
    }

    public boolean m_6777_(BlockState blockState, Level level, BlockPos blockPos, Player player) {
        return true;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand interactionHand) {
        return AirSelectionItem.super.useOnAir(level, player, interactionHand);
    }

    public static DebugDataItem forLootTable(ResourceLocation table, Item icon) {
        ResourceLocation iconId = BuiltInRegistries.f_257033_.m_7981_((Object)icon);
        return new DebugDataItem((player, entity, ctx) -> {
            CompoundTag tag = entity.m_187482_();
            tag.m_128473_("LootTableSeed");
            tag.m_128473_("Items");
            tag.m_128359_("LootTable", table.toString());
            entity.m_142466_(tag);
            DebugDataItem.message(player, "Did set Loot Table to " + table.toString());
            return InteractionResult.SUCCESS;
        }, false, iconId);
    }

    public static DebugDataItem forSpawner(CompoundTag tag, Item icon) {
        ResourceLocation iconId = BuiltInRegistries.f_257033_.m_7981_((Object)icon);
        return new DebugDataItem((player, entity, ctx) -> {
            if (entity instanceof SpawnerBlockEntity) {
                entity.m_142466_(tag);
                DebugDataItem.message(player, "Did set Data to " + tag.toString());
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.FAIL;
        }, false, iconId);
    }

    public static DebugDataItem forSteetJigSaw(String modID, ResourceKey<StructureTemplatePool> pool, Item icon) {
        return DebugDataItem.forJigsaw(pool == null ? Pools.f_127186_ : pool, new ResourceLocation(modID, "street"), JigsawBlockEntity.JointType.ALIGNED, null, null, icon);
    }

    public static DebugDataItem forHouseEntranceJigSaw(String modID, ResourceKey<StructureTemplatePool> pool, Item icon) {
        return DebugDataItem.forJigsaw(pool == null ? Pools.f_127186_ : pool, pool == null ? new ResourceLocation(modID, "building_entrance") : new ResourceLocation(modID, "street_entrance"), pool == null ? new ResourceLocation("street_entrance") : new ResourceLocation(modID, "building_entrance"), JigsawBlockEntity.JointType.ALIGNED, null, null, icon);
    }

    public static DebugDataItem forDecorationJigSaw(String modID, ResourceKey<StructureTemplatePool> pool, Item icon) {
        return DebugDataItem.forJigsaw(pool == null ? Pools.f_127186_ : pool, pool == null ? new ResourceLocation(modID, "side") : new ResourceLocation(modID, "side_street"), pool == null ? new ResourceLocation("side_street") : new ResourceLocation(modID, "side"), JigsawBlockEntity.JointType.ALIGNED, null, null, icon);
    }

    public static DebugDataItem forStreetDecorationJigSaw(String modID, ResourceKey<StructureTemplatePool> pool, Item icon) {
        return DebugDataItem.forJigsaw(pool == null ? Pools.f_127186_ : pool, pool == null ? new ResourceLocation(modID, "bottom") : new ResourceLocation(modID, "bottom_street"), pool == null ? new ResourceLocation("bottom_street") : new ResourceLocation(modID, "bottom"), JigsawBlockEntity.JointType.ROLLABLE, null, pool == null ? FrontAndTop.DOWN_WEST : FrontAndTop.UP_WEST, icon);
    }

    public static DebugDataItem forJigsaw(ResourceKey<StructureTemplatePool> pool, ResourceLocation connector, JigsawBlockEntity.JointType type, BlockState finalState, FrontAndTop forceOrientation, Item icon) {
        return DebugDataItem.forJigsaw(pool, connector, connector, type, finalState, forceOrientation, icon);
    }

    public static DebugDataItem forJigsaw(ResourceKey<StructureTemplatePool> pool, ResourceLocation name, ResourceLocation target, JigsawBlockEntity.JointType type, BlockState finalState, FrontAndTop forceOrientation, Item icon) {
        ResourceLocation iconId = BuiltInRegistries.f_257033_.m_7981_((Object)icon);
        return new DebugDataItem(ctx -> {
            Player player = ctx.m_43723_();
            Level level = ctx.m_43725_();
            BlockPos pos = ctx.m_8083_();
            BlockState state = level.m_8055_(pos);
            BlockEntity entity = level.m_7702_(pos);
            BlockState targetState = finalState;
            if (!(entity instanceof JigsawBlockEntity)) {
                if (targetState == null) {
                    targetState = state.m_60795_() ? Blocks.f_50454_.m_49966_() : state;
                }
                state = Blocks.f_50678_.m_49966_();
                level.m_7731_(pos, state, 18);
                entity = level.m_7702_(pos);
                DebugDataItem.message(player, "Created JigSaw at " + pos.toString());
            }
            if (entity instanceof JigsawBlockEntity) {
                JigsawBlockEntity e = (JigsawBlockEntity)entity;
                state = forceOrientation == null ? PlaceCommand.setJigsawOrientation(JigsawBlockEntity.JointType.ROLLABLE != type, player, pos, state) : (BlockState)state.m_61124_((Property)JigsawBlock.f_54222_, (Comparable)forceOrientation);
                level.m_7731_(pos, state, 18);
                if (pool != null) {
                    e.m_59435_(name);
                }
                if (pool != null) {
                    e.m_59438_(target);
                }
                if (pool != null) {
                    e.m_222763_(pool);
                }
                if (targetState != null) {
                    e.m_59431_(BlockStateParser.m_116769_((BlockState)targetState));
                }
                e.m_59424_(type);
                DebugDataItem.message(player, "Did update Jigsaw at " + pos.toString());
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.FAIL;
        }, true, iconId);
    }

    public static interface BlockStatePredicate {
        public boolean test(BlockState var1);
    }

    public static interface DebugInteraction {
        public InteractionResult use(UseOnContext var1);
    }

    public static interface DebugEntityInteraction
    extends DebugInteraction {
        @Override
        default public InteractionResult use(UseOnContext useOnContext) {
            BlockEntity entity = useOnContext.m_43725_().m_7702_(useOnContext.m_8083_());
            if (entity != null) {
                return this.use(useOnContext.m_43723_(), entity, useOnContext);
            }
            return InteractionResult.FAIL;
        }

        public InteractionResult use(Player var1, BlockEntity var2, UseOnContext var3);
    }
}

